#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Cosmic Force of Mu 2Mod01.fsh  by   beervgeer  
//https://www.shadertoy.com/view/MtKfzz
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.14159265359
#define TWO_PI 6.28318530718
#define time iTime
#define resolution iResolution.xy
#define size 0.0240525
#define lineSize 0.24540144
#define blur 0.227794
#define grid 9.510933
#define morph 5.2208757
#define delayAmount 3.223359
#define delay2 6.429779
#define speed 0.39144516


float impulse( float k, float x )
{
    float h = k*x;
    return h*exp(1.0-h);
}

float plot(float dis){
   float pct = smoothstep(dis,dis+blur,0.5)-smoothstep(lineSize+dis,lineSize+dis+blur,0.5);     
  return   pct ;
}


vec3 rgb2hsb( in vec3 c ){
    vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
    vec4 p = mix(vec4(c.bg, K.wz),
                 vec4(c.gb, K.xy),
                 step(c.b, c.g));
    vec4 q = mix(vec4(p.xyw, c.r),
                 vec4(c.r, p.yzx),
                 step(p.x, c.r));
    float d = q.x - min(q.w, q.y);
    float e = 1.0e-10;
    return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)),
                d / (q.x + e),
                q.x);
}

//  Function from Iñigo Quiles
//  https://www.shadertoy.com/view/MsS3Wc
vec3 hsb2rgb( in vec3 c ){
    vec3 rgb = clamp(abs(mod(c.x*6.0+vec3(0.0,4.0,2.0),
                             6.0)-3.0)-1.0,
                     0.0,
                     1.0 );
    rgb = rgb*rgb*(3.0-2.0*rgb);
    return c.z * mix(vec3(1.0), rgb, c.y);
}
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
     vec2 res = vec2(0);
    res.x = resolution.x*0.5625;
    res.y = resolution.y;
    
   vec2 st = gl_FragCoord.xy/res;
 st.x -= 0.35;
  float d = 0.0;

  // Remap the space to -1. to 1.
  st = st *2.-1.;
  
  // Number of sides of your shape
  int N = 3;

  // Angle and radius from the current pixel
  vec3 colorNew = vec3(0);
  
  for(int i=0;i<5;i++) {
      
      float m = (float(i)/5.);
      st.y += size*m*sin(time/3.);
      float a = atan(st.x,st.y)+PI+(morph*m) + (0.03*m * sin(time));
      float r = TWO_PI/float(N);
      
      d = cos(floor(.5+a/r)*r-a )*length(st);
      d = impulse(d,delayAmount);
      vec3 color = vec3(0.0);
      float check = delay2 * (1.-length(st));
      color.r = plot(fract(d*grid - check + time*speed));
      color.g = plot(fract(d*grid - check + time*speed*0.8));
      color.b = plot(fract(d*grid - check + time*speed*0.6));
      colorNew+= ( color*m );
    }
    
    
 
   vec3 hue = rgb2hsb(colorNew);
    hue.x = 0.6;
    hue.y = 0.5;
    hue.y = 0.5;
    fragColor = vec4( hsb2rgb(hue)-colorNew*0.2 ,1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

